/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.blaze3d.vertex.MatrixApplyingVertexBuilder;
import com.mojang.blaze3d.vertex.VertexBuilderUtils;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BreakableBlock;
import net.minecraft.block.StainedGlassPaneBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.ItemModelMesherForge;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.VanillaResourceType;

@OnlyIn(value=Dist.CLIENT)
public class ItemRenderer
implements IResourceManagerReloadListener {
    public static final ResourceLocation field_110798_h = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private static final Set<Item> field_195411_c = Sets.newHashSet((Object[])new Item[]{Items.field_190931_a});
    public float field_77023_b;
    private final ItemModelMesher field_175059_m;
    private final TextureManager field_175057_n;
    private final ItemColors field_184395_f;

    public ItemRenderer(TextureManager p_i46552_1_, ModelManager p_i46552_2_, ItemColors p_i46552_3_) {
        this.field_175057_n = p_i46552_1_;
        this.field_175059_m = new ItemModelMesherForge(p_i46552_2_);
        for (Item item : Registry.field_212630_s) {
            if (field_195411_c.contains((Object)item)) continue;
            this.field_175059_m.func_199311_a(item, new ModelResourceLocation(Registry.field_212630_s.func_177774_c((Object)item), "inventory"));
        }
        this.field_184395_f = p_i46552_3_;
    }

    public ItemModelMesher func_175037_a() {
        return this.field_175059_m;
    }

    public void func_229114_a_(IBakedModel p_229114_1_, ItemStack p_229114_2_, int p_229114_3_, int p_229114_4_, MatrixStack p_229114_5_, IVertexBuilder p_229114_6_) {
        Random random = new Random();
        long i = 42L;
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            this.func_229112_a_(p_229114_5_, p_229114_6_, p_229114_1_.func_200117_a(null, direction, random), p_229114_2_, p_229114_3_, p_229114_4_);
        }
        random.setSeed(42L);
        this.func_229112_a_(p_229114_5_, p_229114_6_, p_229114_1_.func_200117_a(null, null, random), p_229114_2_, p_229114_3_, p_229114_4_);
    }

    public void func_229111_a_(ItemStack p_229111_1_, ItemCameraTransforms.TransformType p_229111_2_, boolean p_229111_3_, MatrixStack p_229111_4_, IRenderTypeBuffer p_229111_5_, int p_229111_6_, int p_229111_7_, IBakedModel p_229111_8_) {
        if (!p_229111_1_.func_190926_b()) {
            boolean flag;
            p_229111_4_.func_227860_a_();
            boolean bl = flag = p_229111_2_ == ItemCameraTransforms.TransformType.GUI || p_229111_2_ == ItemCameraTransforms.TransformType.GROUND || p_229111_2_ == ItemCameraTransforms.TransformType.FIXED;
            if (p_229111_1_.func_77973_b() == Items.field_203184_eO && flag) {
                p_229111_8_ = this.field_175059_m.func_178083_a().func_174953_a(new ModelResourceLocation("minecraft:trident#inventory"));
            }
            p_229111_8_ = ForgeHooksClient.handleCameraTransforms((MatrixStack)p_229111_4_, (IBakedModel)p_229111_8_, (ItemCameraTransforms.TransformType)p_229111_2_, (boolean)p_229111_3_);
            p_229111_4_.func_227861_a_(-0.5, -0.5, -0.5);
            if (!p_229111_8_.func_188618_c() && (p_229111_1_.func_77973_b() != Items.field_203184_eO || flag)) {
                Block block;
                boolean flag1 = p_229111_2_ != ItemCameraTransforms.TransformType.GUI && !p_229111_2_.func_241716_a_() && p_229111_1_.func_77973_b() instanceof BlockItem ? !((block = ((BlockItem)p_229111_1_.func_77973_b()).func_179223_d()) instanceof BreakableBlock) && !(block instanceof StainedGlassPaneBlock) : true;
                if (p_229111_8_.isLayered()) {
                    ForgeHooksClient.drawItemLayered((ItemRenderer)this, (IBakedModel)p_229111_8_, (ItemStack)p_229111_1_, (MatrixStack)p_229111_4_, (IRenderTypeBuffer)p_229111_5_, (int)p_229111_6_, (int)p_229111_7_, (boolean)flag1);
                } else {
                    IVertexBuilder ivertexbuilder;
                    RenderType rendertype = RenderTypeLookup.func_239219_a_(p_229111_1_, flag1);
                    if (p_229111_1_.func_77973_b() == Items.field_151111_aL && p_229111_1_.func_77962_s()) {
                        p_229111_4_.func_227860_a_();
                        MatrixStack.Entry matrixstack$entry = p_229111_4_.func_227866_c_();
                        if (p_229111_2_ == ItemCameraTransforms.TransformType.GUI) {
                            matrixstack$entry.func_227870_a_().func_226592_a_(0.5f);
                        } else if (p_229111_2_.func_241716_a_()) {
                            matrixstack$entry.func_227870_a_().func_226592_a_(0.75f);
                        }
                        ivertexbuilder = flag1 ? ItemRenderer.func_241732_b_(p_229111_5_, rendertype, matrixstack$entry) : ItemRenderer.func_241731_a_(p_229111_5_, rendertype, matrixstack$entry);
                        p_229111_4_.func_227865_b_();
                    } else {
                        ivertexbuilder = flag1 ? ItemRenderer.func_239391_c_(p_229111_5_, rendertype, true, p_229111_1_.func_77962_s()) : ItemRenderer.func_229113_a_(p_229111_5_, rendertype, true, p_229111_1_.func_77962_s());
                    }
                    this.func_229114_a_(p_229111_8_, p_229111_1_, p_229111_6_, p_229111_7_, p_229111_4_, ivertexbuilder);
                }
            } else {
                p_229111_1_.func_77973_b().getItemStackTileEntityRenderer().func_239207_a_(p_229111_1_, p_229111_2_, p_229111_4_, p_229111_5_, p_229111_6_, p_229111_7_);
            }
            p_229111_4_.func_227865_b_();
        }
    }

    public static IVertexBuilder func_239386_a_(IRenderTypeBuffer p_239386_0_, RenderType p_239386_1_, boolean p_239386_2_, boolean p_239386_3_) {
        return p_239386_3_ ? VertexBuilderUtils.func_227915_a_((IVertexBuilder)p_239386_0_.getBuffer(p_239386_2_ ? RenderType.func_239270_k_() : RenderType.func_239271_l_()), (IVertexBuilder)p_239386_0_.getBuffer(p_239386_1_)) : p_239386_0_.getBuffer(p_239386_1_);
    }

    public static IVertexBuilder func_241731_a_(IRenderTypeBuffer p_241731_0_, RenderType p_241731_1_, MatrixStack.Entry p_241731_2_) {
        return VertexBuilderUtils.func_227915_a_((IVertexBuilder)new MatrixApplyingVertexBuilder(p_241731_0_.getBuffer(RenderType.func_228653_j_()), p_241731_2_.func_227870_a_(), p_241731_2_.func_227872_b_()), (IVertexBuilder)p_241731_0_.getBuffer(p_241731_1_));
    }

    public static IVertexBuilder func_241732_b_(IRenderTypeBuffer p_241732_0_, RenderType p_241732_1_, MatrixStack.Entry p_241732_2_) {
        return VertexBuilderUtils.func_227915_a_((IVertexBuilder)new MatrixApplyingVertexBuilder(p_241732_0_.getBuffer(RenderType.func_239273_n_()), p_241732_2_.func_227870_a_(), p_241732_2_.func_227872_b_()), (IVertexBuilder)p_241732_0_.getBuffer(p_241732_1_));
    }

    public static IVertexBuilder func_229113_a_(IRenderTypeBuffer p_229113_0_, RenderType p_229113_1_, boolean p_229113_2_, boolean p_229113_3_) {
        if (p_229113_3_) {
            return Minecraft.func_238218_y_() && p_229113_1_ == Atlases.func_239280_i_() ? VertexBuilderUtils.func_227915_a_((IVertexBuilder)p_229113_0_.getBuffer(RenderType.func_243501_m()), (IVertexBuilder)p_229113_0_.getBuffer(p_229113_1_)) : VertexBuilderUtils.func_227915_a_((IVertexBuilder)p_229113_0_.getBuffer(p_229113_2_ ? RenderType.func_228653_j_() : RenderType.func_228655_k_()), (IVertexBuilder)p_229113_0_.getBuffer(p_229113_1_));
        }
        return p_229113_0_.getBuffer(p_229113_1_);
    }

    public static IVertexBuilder func_239391_c_(IRenderTypeBuffer p_239391_0_, RenderType p_239391_1_, boolean p_239391_2_, boolean p_239391_3_) {
        return p_239391_3_ ? VertexBuilderUtils.func_227915_a_((IVertexBuilder)p_239391_0_.getBuffer(p_239391_2_ ? RenderType.func_239273_n_() : RenderType.func_239274_p_()), (IVertexBuilder)p_239391_0_.getBuffer(p_239391_1_)) : p_239391_0_.getBuffer(p_239391_1_);
    }

    public void func_229112_a_(MatrixStack p_229112_1_, IVertexBuilder p_229112_2_, List<BakedQuad> p_229112_3_, ItemStack p_229112_4_, int p_229112_5_, int p_229112_6_) {
        boolean flag = !p_229112_4_.func_190926_b();
        MatrixStack.Entry matrixstack$entry = p_229112_1_.func_227866_c_();
        for (BakedQuad bakedquad : p_229112_3_) {
            int i = -1;
            if (flag && bakedquad.func_178212_b()) {
                i = this.field_184395_f.func_186728_a(p_229112_4_, bakedquad.func_178211_c());
            }
            float f = (float)(i >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
            float f2 = (float)(i & 0xFF) / 255.0f;
            p_229112_2_.addVertexData(matrixstack$entry, bakedquad, f, f1, f2, p_229112_5_, p_229112_6_, true);
        }
    }

    public IBakedModel func_184393_a(ItemStack p_184393_1_, @Nullable World p_184393_2_, @Nullable LivingEntity p_184393_3_) {
        Item item = p_184393_1_.func_77973_b();
        IBakedModel ibakedmodel = item == Items.field_203184_eO ? this.field_175059_m.func_178083_a().func_174953_a(new ModelResourceLocation("minecraft:trident_in_hand#inventory")) : this.field_175059_m.func_178089_a(p_184393_1_);
        ClientWorld clientworld = p_184393_2_ instanceof ClientWorld ? (ClientWorld)p_184393_2_ : null;
        IBakedModel ibakedmodel1 = ibakedmodel.func_188617_f().func_239290_a_(ibakedmodel, p_184393_1_, clientworld, p_184393_3_);
        return ibakedmodel1 == null ? this.field_175059_m.func_178083_a().func_174951_a() : ibakedmodel1;
    }

    public void func_229110_a_(ItemStack p_229110_1_, ItemCameraTransforms.TransformType p_229110_2_, int p_229110_3_, int p_229110_4_, MatrixStack p_229110_5_, IRenderTypeBuffer p_229110_6_) {
        this.func_229109_a_(null, p_229110_1_, p_229110_2_, false, p_229110_5_, p_229110_6_, null, p_229110_3_, p_229110_4_);
    }

    public void func_229109_a_(@Nullable LivingEntity p_229109_1_, ItemStack p_229109_2_, ItemCameraTransforms.TransformType p_229109_3_, boolean p_229109_4_, MatrixStack p_229109_5_, IRenderTypeBuffer p_229109_6_, @Nullable World p_229109_7_, int p_229109_8_, int p_229109_9_) {
        if (!p_229109_2_.func_190926_b()) {
            IBakedModel ibakedmodel = this.func_184393_a(p_229109_2_, p_229109_7_, p_229109_1_);
            this.func_229111_a_(p_229109_2_, p_229109_3_, p_229109_4_, p_229109_5_, p_229109_6_, p_229109_8_, p_229109_9_, ibakedmodel);
        }
    }

    public void func_175042_a(ItemStack p_175042_1_, int p_175042_2_, int p_175042_3_) {
        this.func_191962_a(p_175042_1_, p_175042_2_, p_175042_3_, this.func_184393_a(p_175042_1_, null, null));
    }

    protected void func_191962_a(ItemStack p_191962_1_, int p_191962_2_, int p_191962_3_, IBakedModel p_191962_4_) {
        boolean flag;
        RenderSystem.pushMatrix();
        this.field_175057_n.func_110577_a(AtlasTexture.field_110575_b);
        this.field_175057_n.func_229267_b_(AtlasTexture.field_110575_b).func_174937_a(false, false);
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableAlphaTest();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.translatef((float)p_191962_2_, (float)p_191962_3_, (float)(100.0f + this.field_77023_b));
        RenderSystem.translatef((float)8.0f, (float)8.0f, (float)0.0f);
        RenderSystem.scalef((float)1.0f, (float)-1.0f, (float)1.0f);
        RenderSystem.scalef((float)16.0f, (float)16.0f, (float)16.0f);
        MatrixStack matrixstack = new MatrixStack();
        IRenderTypeBuffer.Impl irendertypebuffer$impl = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        boolean bl = flag = !p_191962_4_.func_230044_c_();
        if (flag) {
            RenderHelper.func_227783_c_();
        }
        this.func_229111_a_(p_191962_1_, ItemCameraTransforms.TransformType.GUI, false, matrixstack, (IRenderTypeBuffer)irendertypebuffer$impl, 0xF000F0, OverlayTexture.field_229196_a_, p_191962_4_);
        irendertypebuffer$impl.func_228461_a_();
        RenderSystem.enableDepthTest();
        if (flag) {
            RenderHelper.func_227784_d_();
        }
        RenderSystem.disableAlphaTest();
        RenderSystem.disableRescaleNormal();
        RenderSystem.popMatrix();
    }

    public void func_180450_b(ItemStack p_180450_1_, int p_180450_2_, int p_180450_3_) {
        this.func_239387_b_(Minecraft.func_71410_x().field_71439_g, p_180450_1_, p_180450_2_, p_180450_3_);
    }

    public void func_239390_c_(ItemStack p_239390_1_, int p_239390_2_, int p_239390_3_) {
        this.func_239387_b_(null, p_239390_1_, p_239390_2_, p_239390_3_);
    }

    public void func_184391_a(LivingEntity p_184391_1_, ItemStack p_184391_2_, int p_184391_3_, int p_184391_4_) {
        this.func_239387_b_(p_184391_1_, p_184391_2_, p_184391_3_, p_184391_4_);
    }

    private void func_239387_b_(@Nullable LivingEntity p_239387_1_, ItemStack p_239387_2_, int p_239387_3_, int p_239387_4_) {
        if (!p_239387_2_.func_190926_b()) {
            this.field_77023_b += 50.0f;
            try {
                this.func_191962_a(p_239387_2_, p_239387_3_, p_239387_4_, this.func_184393_a(p_239387_2_, null, p_239387_1_));
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a(throwable, "Rendering item");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Item being rendered");
                crashreportcategory.func_189529_a("Item Type", (ICrashReportDetail<String>)((ICrashReportDetail)() -> String.valueOf((Object)p_239387_2_.func_77973_b())));
                crashreportcategory.func_189529_a("Registry Name", (ICrashReportDetail<String>)((ICrashReportDetail)() -> String.valueOf(p_239387_2_.func_77973_b().getRegistryName())));
                crashreportcategory.func_189529_a("Item Damage", (ICrashReportDetail<String>)((ICrashReportDetail)() -> String.valueOf(p_239387_2_.func_77952_i())));
                crashreportcategory.func_189529_a("Item NBT", (ICrashReportDetail<String>)((ICrashReportDetail)() -> String.valueOf(p_239387_2_.func_77978_p())));
                crashreportcategory.func_189529_a("Item Foil", (ICrashReportDetail<String>)((ICrashReportDetail)() -> String.valueOf(p_239387_2_.func_77962_s())));
                throw new ReportedException(crashreport);
            }
            this.field_77023_b -= 50.0f;
        }
    }

    public void func_175030_a(FontRenderer p_175030_1_, ItemStack p_175030_2_, int p_175030_3_, int p_175030_4_) {
        this.func_180453_a(p_175030_1_, p_175030_2_, p_175030_3_, p_175030_4_, null);
    }

    public void func_180453_a(FontRenderer p_180453_1_, ItemStack p_180453_2_, int p_180453_3_, int p_180453_4_, @Nullable String p_180453_5_) {
        if (!p_180453_2_.func_190926_b()) {
            ClientPlayerEntity clientplayerentity;
            float f3;
            MatrixStack matrixstack = new MatrixStack();
            if (p_180453_2_.func_190916_E() != 1 || p_180453_5_ != null) {
                String s = p_180453_5_ == null ? String.valueOf(p_180453_2_.func_190916_E()) : p_180453_5_;
                matrixstack.func_227861_a_(0.0, 0.0, (double)(this.field_77023_b + 200.0f));
                IRenderTypeBuffer.Impl irendertypebuffer$impl = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
                p_180453_1_.func_228079_a_(s, (float)(p_180453_3_ + 19 - 2 - p_180453_1_.func_78256_a(s)), (float)(p_180453_4_ + 6 + 3), 0xFFFFFF, true, matrixstack.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)irendertypebuffer$impl, false, 0, 0xF000F0);
                irendertypebuffer$impl.func_228461_a_();
            }
            if (p_180453_2_.func_77973_b().showDurabilityBar(p_180453_2_)) {
                RenderSystem.disableDepthTest();
                RenderSystem.disableTexture();
                RenderSystem.disableAlphaTest();
                RenderSystem.disableBlend();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                double health = p_180453_2_.func_77973_b().getDurabilityForDisplay(p_180453_2_);
                int i = Math.round(13.0f - (float)health * 13.0f);
                int j = p_180453_2_.func_77973_b().getRGBDurabilityForDisplay(p_180453_2_);
                this.func_181565_a(bufferbuilder, p_180453_3_ + 2, p_180453_4_ + 13, 13, 2, 0, 0, 0, 255);
                this.func_181565_a(bufferbuilder, p_180453_3_ + 2, p_180453_4_ + 13, i, 1, j >> 16 & 0xFF, j >> 8 & 0xFF, j & 0xFF, 255);
                RenderSystem.enableBlend();
                RenderSystem.enableAlphaTest();
                RenderSystem.enableTexture();
                RenderSystem.enableDepthTest();
            }
            float f = f3 = (clientplayerentity = Minecraft.func_71410_x().field_71439_g) == null ? 0.0f : clientplayerentity.func_184811_cZ().func_185143_a(p_180453_2_.func_77973_b(), Minecraft.func_71410_x().func_184121_ak());
            if (f3 > 0.0f) {
                RenderSystem.disableDepthTest();
                RenderSystem.disableTexture();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                Tessellator tessellator1 = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder1 = tessellator1.func_178180_c();
                this.func_181565_a(bufferbuilder1, p_180453_3_, p_180453_4_ + MathHelper.func_76141_d((float)(16.0f * (1.0f - f3))), 16, MathHelper.func_76123_f((float)(16.0f * f3)), 255, 255, 255, 127);
                RenderSystem.enableTexture();
                RenderSystem.enableDepthTest();
            }
        }
    }

    private void func_181565_a(BufferBuilder p_181565_1_, int p_181565_2_, int p_181565_3_, int p_181565_4_, int p_181565_5_, int p_181565_6_, int p_181565_7_, int p_181565_8_, int p_181565_9_) {
        p_181565_1_.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        p_181565_1_.func_225582_a_(p_181565_2_ + 0, p_181565_3_ + 0, 0.0).func_225586_a_(p_181565_6_, p_181565_7_, p_181565_8_, p_181565_9_).func_181675_d();
        p_181565_1_.func_225582_a_(p_181565_2_ + 0, p_181565_3_ + p_181565_5_, 0.0).func_225586_a_(p_181565_6_, p_181565_7_, p_181565_8_, p_181565_9_).func_181675_d();
        p_181565_1_.func_225582_a_(p_181565_2_ + p_181565_4_, p_181565_3_ + p_181565_5_, 0.0).func_225586_a_(p_181565_6_, p_181565_7_, p_181565_8_, p_181565_9_).func_181675_d();
        p_181565_1_.func_225582_a_(p_181565_2_ + p_181565_4_, p_181565_3_ + 0, 0.0).func_225586_a_(p_181565_6_, p_181565_7_, p_181565_8_, p_181565_9_).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    @Override
    public void func_195410_a(IResourceManager p_195410_1_) {
        this.field_175059_m.func_178085_b();
    }

    @Override
    public IResourceType getResourceType() {
        return VanillaResourceType.MODELS;
    }
}

